//------------------------------------------------------------
// Ambient blinking
// 2024-02-27 RSP
// Target: RP2040 + Any number of button panels
//------------------------------------------------------------

#include "VelociBus_4X4BP.h"
#define VBUS_SERIAL Serial2
VelociBus_4X4BP vbus;

struct board_cell
{ VelociBus_4X4BP::color_code color;
  uint  state;
  uint32_t tm;
  uint32_t on_time;
};
struct board { board_cell cell[16]; };
board *bp; // dynamically allocated for actual number of button panels

#define FADEOUT_MSECS 1000

//------------------------------------------------------

void setup() 
{
  VBUS_SERIAL.begin(38400); // VelociBus is always 38400
  // get number of boards
  vbus.begin( &VBUS_SERIAL, 0 ); // retry until at least one board is found
  // blank display
  vbus.setLEDall( VelociBus_4X4BP::BOARD_BROADCAST_ADDR, VelociBus_4X4BP::FCN_COLOR, VelociBus_4X4BP::black );

  // create board image
  bp = new board[vbus.board_count];

  for (uint b=0; b < vbus.board_count; b++)
    for (uint i=0; i < 16; i++)
      bp[b].cell[i].state = 0;
}

void loop() 
{
  // light up new cell
  for (uint m=0; m < 25; m++) // random tries
  { // look for dark cell
    uint b = random(0,vbus.board_count);
    uint i = random(0,16);
    if (bp[b].cell[i].state) continue;
    // start cell
    bp[b].cell[i].color = (VelociBus_4X4BP::color_code)random(1,16);
    bp[b].cell[i].tm = millis();
    bp[b].cell[i].state = 1;
    bp[b].cell[i].on_time = random(1000,5000);
    vbus.setLED( b,i, VelociBus_4X4BP::FCN_COLOR, bp[b].cell[i].color );
    break;
  }
  
  // animate
  uint32_t frame_ms = random(10,250);
  for (uint32_t tx=millis(); millis()-tx < frame_ms; )
  {
    for (uint b=0; b < vbus.board_count; b++)
      for (uint i=0; i < 16; i++)
        switch (bp[b].cell[i].state)
        {
          case 1: // on
            if (millis()-bp[b].cell[i].tm > bp[b].cell[i].on_time)
            { bp[b].cell[i].state = 2;
              bp[b].cell[i].tm = millis();
              vbus.setLED( b,i, VelociBus_4X4BP::FCN_FADEOUT, bp[b].cell[i].color );
            }
            break;
            
          case 2: // fading
            if (millis()-bp[b].cell[i].tm > FADEOUT_MSECS)
              bp[b].cell[i].state = 0; // square should be dark
            break;
          
          case 0: // empty
          default: bp[b].cell[i].state = 0;
        }      
  }
}
